<?php
	session_start();
	
	$pageTitle = "Solve the Code!";
	
	$baseDirectory = getcwd() . "/";
	
	require_once($baseDirectory . "game.php");
	require_once($baseDirectory . "header.php");
	
	$myGame = new Game();
	$displayScreen = new displayScreen();
	
	if (isset($_POST["guess"]))
		$myGame->submitGuess($_POST["guess"]);
?>

<h1>Welcome Player! Can You Solve the Code?</h1>

<div id="tabs">
	<ul>
		<li><a href="#gameScreen">Play</a></li>
		<?php
			if (count($myGame->aGuesses) > 0)
				echo '<li><a href="#previousGuesses">Previous Guesses</a></li>';
		?>
		<li><a href="#instructions">Instructions</a></li>
	</ul>
	<div id="gameScreen">
		<?php
			if (count($myGame->aGuesses) == 0)
				echo "<h2>Game Start!</h2>";
			elseif ($myGame->hasWon)
				echo '<h2 class="winner">You Win!</h2>';
			elseif ($myGame->gameOver)
				echo '<h2 class="lost">Sorry, you ran out of turns.  The correct number was ' . implode($myGame->aCorrectNumber) . "</h2>";
			else
				echo "<h2>You Have " . ($myGame::numTriesAllowed - count($myGame->aGuesses)) . " Guesses Left!</h2>";
				
		?>
	
			<div id="codeScreen">
				<?php 
					foreach($myGame->aLastGuess as $key => $value) {
						echo '<img src="' . $displayScreen->generateImage($value, $myGame->aNumberStates[$key]) . '" />';
					}
				?>
			</div>
		
		<?php	
			if (!$myGame->gameOver && !$myGame->hasWon) {
		?>
			<form action="index.php" method="post">
				<table style="width: 200px; margin-right: auto; margin-left: auto;">
				<tr>
					<th><label for="guess" class="required">What's Your Guess:</label></th>
					<td><input type="text" name="guess" id="guess" maxlength="4" size="5" autocomplete="off" /></td>
				</tr>
				</table>
				<button name="submit" id="submitGuess" type="submit">Check It</button>
			</form>
		<?php
			}
			else
				echo '<h3>Would you like to play again?</h3>' . "\n"
					. '<h3><a href="index.php">Yes!</a> ~ <a href="http://google.com">No</a></h3>' . "\n";
		?>
	</div>
	<?php
		if (count($myGame->aGuesses) > 0)
			echo '<div id="previousGuesses">';

		if (count($myGame->aGuesses) > 0) {
			echo "<ul>" . "\n";
			
			foreach($myGame->aGuesses as $thisGuess) {
				echo "<li>" . $thisGuess . "</li>\n";
			}
			echo "</ul>" . "\n";
		}

		if (count($myGame->aGuesses) > 0)
			echo '</div>';
	?>
	<div id="instructions">
		<p>How to play:</p>
		<ul>
			<li>A four digit code has been randomly selected</li>
			<li>Enter in a possible code, each digit can be any number from 0 to 9</li>
			<li>The numbers on the game screen will change colors based on your last guess:
				<ul>
					<li><strong style="color: #F00;">Red</strong> - wrong</li>
					<li><strong style="color: #FF0;">Yellow</strong> - close</li>
					<li><strong style="color: #0F0;">Green</strong> - correct</li>
				</ul>
			</li>
			<li>Keep guessing until you get it right - but remember, you only get <?php echo Game::numTriesAllowed; ?> tries, then the code is reset!</li>
		</ul>
	</div>
</div>

<?php
	if($myGame->gameOver || $myGame->hasWon)
		$myGame->resetGame();
	
	require_once("footer.php");
?>