<?php
	class Game {
		// set our initial constant and our properties
		const numTriesAllowed = 10;
		
		public $aGuesses = array();
		public $aLastGuess = array('*','*','*','*');
		public $aNumberStates = array("wrong","wrong","wrong","wrong");
		public $aCorrectNumber = array();
		public $hasWon = false;
		public $gameOver = false;

		// on first load, check to see if we have a number right now; if not, make one because its a new game
		public function __construct(){
			$this->getCorrectNumber();
			
			if (count($this->aCorrectNumber) != 4)
				$this->generateNumber();
		}
		
		// get the current winning number and the previous guesses, if any, and put in the appropriate property
		public function getCorrectNumber() {
			if (isset($_SESSION['CorrectNumber'])) {
				$this->aCorrectNumber = str_split($_SESSION["CorrectNumber"]);
				
				if (isset($_SESSION['Guesses']))
					$this->aGuesses = $_SESSION["Guesses"];
			}
			else {
				$aCorrectNumber = $this->aCorrectNumber;
			}
		}
		
		// Generate a new random number - done as a loop so we can have 0 as the first number too
		public function generateNumber(){
			$aCorrectNumber = $this->aCorrectNumber;
			
			if (count($aCorrectNumber) != 4) {
				$aNewNumber = array();
				
				while (count($aNewNumber) != 4) {
					array_push($aNewNumber, rand(0, 9));
				}
				
				$this->aCorrectNumber = $aNewNumber;
				$_SESSION["CorrectNumber"] = implode($aNewNumber);
			}
		}
		
		// If we have a new guess, store it then call the appropriate functions to check it, store it, and see how the player is doing
		public function submitGuess($newGuess){
			if ($newGuess != '') {
				$this->aLastGuess = str_split($newGuess);
				$this->checkGuess();
				$this->addGuessToList($newGuess);
				$this->checkTurns();
			}
		}
		
		// Compare guess to correct number and determine the state; store status in appropriate array
		public function checkGuess(){
			$aNewGuess = $this->aLastGuess;
			$aCorrectNumber = $this->aCorrectNumber;
			$numberstate = "wrong";
			
			if(count($aNewGuess) == 4) {
				for ($counter = 0; $counter <= 3; $counter++){
					$checkValue = abs($aCorrectNumber[$counter] - $aNewGuess[$counter]);
					$checkValue2 = abs($aNewGuess[$counter] - $aCorrectNumber[$counter]);
					
					if ($checkValue == 0)
						$numberstate = "correct";
					elseif ($checkValue <= 2 || $checkValue2 <=2)
						$numberstate = "close";
					else
						$numberstate = "wrong";
						
					$this->aNumberStates[$counter] = $numberstate;
				}
				
				// if the number is spot on, flip the win flag on, yay!
				if ($aNewGuess === $aCorrectNumber) {
					$this->hasWon = true;
					$this->gameOver = true;
				}
			}
			// if they don't give us four numbers - punish them with all wrongs!!!
			else {
				for ($counter = 0; $counter <= 3; $counter++){
					$this->aNumberStates[$counter] = $numberstate;
				}	
			}
		}
		
		// Add new guesses to stored array
		public function addGuessToList($newGuess){
			array_push($this->aGuesses, $newGuess);
			$_SESSION["Guesses"] = $this->aGuesses;
		}
		
		// how many turns have they used? If its 10 or more, gmae is over!
		public function checkTurns(){
			if(count($this->aGuesses) >= 10) {
				$this->gameOver = true;
				$this->getCorrectNumber();
				$_SESSION["CorrectNumber"] = '';
			}
		}
		
		// reset the game after a win or game is over; this is separate for a very important reason....
		public function resetGame(){
			$this->aLastGuess = array('*','*','*','*');
			$this->aGuesses = array();
			$this->aCorrectNumber = array();
			$this->aNumberStates = array("wrong","wrong","wrong","wrong");
			$this->hasWon = false;
			$this->gameOver = false;
			$_SESSION["CorrectNumber"] = '';
			$_SESSION["Guesses"] = $this->aGuesses;
		}
	}
	
	// a simple glass for generating the display "screen" for the code, including coloring each digit appropriately for the status
	class displayScreen {
		public function generateImage($numberToDisplay, $numberState){
			$correct = array(0,255,0);
			$close = array(255,255,0);
			$wrong = array(255,0,0);
			
			$font = "Audiowide";
			
			$filename = $numberToDisplay . "_" . $numberState . ".png";
			$newImage = imageCreateTrueColor(100, 100);
			$aColors = $$numberState;
			
			$text_color = imageColorAllocate($newImage, $aColors[0], $aColors[1], $aColors[2]);
			
			imagettftext($newImage, 75, 0, 5, 85, $text_color, $font,  $numberToDisplay);
			imagepng($newImage, $filename);
			imagedestroy($newImage);
			
			return $filename; 
		}
	}
?>